'use client'

import { useRoom } from './room-context'
import { useState } from 'react'
import * as Ty from './interface'

export default function SendMessageProvider() {

    const { username, currentRoomInfo, triggerRefresh } = useRoom()
    const [text, setText] = useState('');
    const [sendError, setSendError] = useState<string | null>(null);

    /*
    - url: /api/message/add
    - method: POST
    - argument:
    interface MessageAddArgs {
        roomId: number;
        content: string;
        sender: string;
    }
    - response: null （只要code为0即为成功）
    */
   const sendMessage = async () => {
       setSendError(null);

       if (!currentRoomInfo) return;

       const Args : Ty.MessageAddArgs = {
           roomId: currentRoomInfo.roomId,
           content: text,
           sender: username
       };

       try {
           const response = await fetch(`${Ty.urlPrefix}/api/message/add`, {
               method: 'POST',
               headers: {
                   'Content-Type': 'application/json'
               },
               body: JSON.stringify(Args)
           });

           const data: Ty.BackendResponse<null> = await response.json();

           if (data.code === 0) {
               setText('');
               triggerRefresh();
           } else {
               throw new Error(`发送失败: ${data.message}`);
           }
       } catch (error) {
           setSendError(error.message);
       }
    }

    return (
        <>
            {sendError && <div className="text-red-500">{sendError}</div>}
            <textarea 
                className="w-full resize-none" 
                rows={4} 
                placeholder={currentRoomInfo ? '输入消息...' : '请选择房间后再发送消息'}
                value={text}
                onChange={(e) => setText(e.target.value)}
                disabled={!currentRoomInfo}
            />
            <button 
                className={
                    currentRoomInfo && text.length ?
                    "bg-blue-500 text-white py-2 px-4 mt-2 w-full hover:bg-blue-600 active:bg-blue-700" :
                    "bg-gray-300 text-gray-500 py-2 px-4 mt-2 w-full cursor-not-allowed"
                }
                onClick={sendMessage}
            >
                发送
            </button>
        </>
    )
}