'use client'
import { createContext, useContext, useState, ReactNode, useCallback } from 'react'
import * as Ty from './interface'
import { useSearchParams} from 'next/navigation';

interface RoomCtxValue {
  currentRoomInfo: Ty.RoomPreviewInfo | null
  setCurrentRoomInfo: (r: Ty.RoomPreviewInfo | null) => void
  username: string;
  setUsername: (u: string) => void;
  msgVersion: number;
  triggerRefresh: () => void;
}

const RoomContext = createContext<RoomCtxValue>({} as RoomCtxValue)

export function RoomProvider({ children }: { children: ReactNode }) {
  const searchParams = useSearchParams();
  const userName = searchParams.get('username')?.trim() || '';
  
  const [currentRoomInfo, setCurrentRoomInfo] = useState<Ty.RoomPreviewInfo | null>(null)
  const [username, setUsername] = useState<string>(userName);
  const [msgVersion, setMsgVersion] = useState(0);

  const triggerRefresh = useCallback(() => setMsgVersion(v => v + 1), []);

  return (
    <RoomContext.Provider value={{ 
      currentRoomInfo, 
      setCurrentRoomInfo, 
      username, 
      setUsername, 
      msgVersion, 
      triggerRefresh
      }}>
      {children}
    </RoomContext.Provider>
  )
}

export const useRoom = () => useContext(RoomContext)