'use client';
import { useState } from 'react';
import { useRouter } from 'next/navigation';

export default function Home() {
  const [username, setUsername] = useState('');
  const router = useRouter();

  const handleSubmit = () => {
    if (!username.trim()) return; // 简单校验
    router.push(`/chat?username=${encodeURIComponent(username)}`);
  };

  return (
    <div className="bg-gray-100 h-screen flex flex-col items-center justify-center">
      <h1 className="text-2xl mb-4">请输入用户名</h1>
      <input
        className="border border-gray-300 rounded px-3 py-2 mb-4"
        placeholder="用户名"
        value={username}
        onChange={(e) => setUsername(e.target.value)}
        required
      />
      <button
        className=
            {username.length ? 
                "bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600 active:bg-blue-700" :
                "bg-gray-300 text-gray-500 px-4 py-2 rounded cursor-not-allowed"
            }
        onClick={handleSubmit}
      >
        进入聊天室
      </button>
    </div>
  );
}