import * as Ty from './interface'
import RoomListProvider from './room-list';
import RoomHeaderProvider from './current-room';
import RoomMessageProvider from './room-message';
import SendMessageProvider from './send-message';
import UsernameCheck from './username-check';
import { RoomProvider } from './room-context'

export default function Home() {
  

  return (
    <RoomProvider>
      <UsernameCheck />
      <div className="bg-gray-100">
        <div className="flex h-screen">
          <div className="w-1/4 bg-white p-4 overflow-y-auto">
            <h2 className="text-lg font-bold mb-4">房间列表</h2>
            <RoomListProvider />
          </div>
        
          <div className="w-3/4 bg-gray-100 p-4">
                <div className="bg-white p-4 mb-4">
                    <RoomHeaderProvider />
                </div>

                <RoomMessageProvider />

                <div className="bg-white p-4">
                    <SendMessageProvider />
                </div>
            </div>
          </div>
      </div>
    </RoomProvider>
  );
}
