import { PrismaClient } from "@/generated/prisma";
import { createClient, RedisClientType } from 'redis';
import { RateLimiterRedis } from 'rate-limiter-flexible';

declare global{
    var prisma:PrismaClient | undefined;
    var redisClient: RedisClientType | undefined;
    var rateLimiter:RateLimiterRedis | undefined;
}


const connectRedisClient = async () => {
    const isBuild = process.env.NEXT_PHASE === 'phase-production-build';

    const client = isBuild ? undefined : createClient();
    client?.on('error', (err) => console.error('Redis Client Error', err));
    await client?.connect();
    return client;
};

const getRateLimiter = () => {
    const isBuild = process.env.NEXT_PHASE === 'phase-production-build';
    if(isBuild) return undefined;

    const rateLimiter = new RateLimiterRedis({
        storeClient: redis,
        keyPrefix: 'rateLimiter',
        points: 5, // 5 points
        duration: 1, // per second
    });
    return rateLimiter;
};



export const prisma = global.prisma || new PrismaClient();
export const redis  = global.redisClient || await connectRedisClient();
export const rateLimiter = global.rateLimiter || getRateLimiter();

if(process.env.NODE_ENV!=='production'){
    global.prisma=prisma;
}