import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';
import { RoomAddArgsSchema } from '../../interface-schema';

/*
- url: /api/room/add
- method: POST
- argument:
interface RoomAddArgs {
    user: string;
    roomName: string;
}
- response:
interface RoomAddRes {
    roomId: number;
}
*/
export async function POST(req: NextRequest) : Promise<NextResponse<Ty.BackendResponse<null | Ty.UserNameRedirectArgs | Ty.RoomAddResult>>> {

    const cookieData = await Db.VerifyCookie(req.cookies);
    if('code' in cookieData)return NextResponse.json(cookieData);

    const parseResult = RoomAddArgsSchema.safeParse(await req.json());
    if(!parseResult.success) return Db.IncorrectArgumentResponse(parseResult.error);

    const { user, roomName }: Ty.RoomAddArgs = parseResult.data;
    const checkResult = await Db.CheckUser(user, cookieData.userToken);
    if (!checkResult) return Db.IncorrectUserResponse(cookieData.userToken);

    const response = await Db.AddRoom({ user, roomName });
    return NextResponse.json(response);
}