import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/auth/logout
- method: POST
- Read & Check Cookie
*/
export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<null>>> {

    const cookieData = await Db.VerifyCookie(req.cookies)
    if('code' in cookieData)return NextResponse.json(cookieData);

    const logoutResult = await Db.Logout(cookieData);

    const res = NextResponse.json(logoutResult);
    res.cookies.set('userToken', '', { maxAge: 0, path: '/' });
    res.cookies.set('authToken', '', { maxAge: 0, path: '/' });

    return res;
}