import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';
import * as Auth from '../../login-interface';

/*
- url: /api/auth/autoLogin
- method: POST
- Read & Check Cookie
*/
export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Auth.LoginResult | null>>> {

    const cookieData = await Db.VerifyCookie(req.cookies)
    if('code' in cookieData) return NextResponse.json(cookieData);

    const Args: Auth.AutoLoginArgs = {
        cookie: cookieData
    };
    const loginResult = await Db.AutoLogin(Args)
    return NextResponse.json(loginResult)
}