// @ts-check

import { format } from 'https://esm.run/date-fns';

/**
 * @param {Date} from
 * @param {Date} to
 * @return {string}
 */
function getTimeDiffString(from, to) {
  if(from > to) {
    throw new Error('from must be less than to');
  }
  // use date-fns here
  return "not implemented";
}

/**
 * @param {number} id
 * @param {string} title
 * @param {string} content
 * @param {Date} deadline 
 */
function addTodoToDOM(id, title, content, deadline) {
  // bonus: save all todos into localStorage

  const newId = "todo-" + id;
  const todoElem = document.createElement("???");
  const todoTitleElem = document.createElement("???");
  const todoContentElem = document.createElement("???");
  const todoDeadlineElem = document.createElement("???");

  todoElem.id = newId;
  todoTitleElem.textContent = ???;

  ...

  const parentElem = document.getElementById("???");
  if (!parentElem) {
    alert("Failed to get input element");
    return;
  }
  parentElem.appendChild(???);
}

/**
 * @param {number} id
 */
function resolveTodo(id) {
  const todo = document.getElementById("todo-" + ???);
  if (!todo) {
    return;
  }

  todo.setAttribute("x-resolved", "1");
  todo.style.color = "???";  // set color to gray
}

/**
 * @param {number} id
 */
function updateOverdueStatus(id) {
  const todo = document.getElementById("todo-" + ???);
  if (!todo) {
    return;
  }
  if (todo.getAttribute("x-resolved") === "1") {
    return;
  }

  const todoDeadlineElemSet = todo.getElementsByTagName("???");  // ref: index.html example todo div
  if (todoDeadlineElemSet.length !== 1) {
    alert("Failed to get deadline element: unexpected number of <???> elements");
  }
  const todoDeadline = todoDeadlineElemSet[0].???;  // get text content of element
  const deadline = ???; // use date-fns here to parse date string
  if (deadline > ???) {
    todo.style.??? = "???";  // set color to red
  }
}


function initializeTodoApp() {
  // bonus: load all saved todos from localStorage

  const addTodoRegex = /^add (\w+) ???? ????$/;
  const modifyTodoRegex = ???;
  const resolveTodoRegex = ???;
  const deleteTodoRegex = ???;


  const shellInputElem = /** @type {HTMLInputElement | null} */ (document.getElementById("???"));
  if (shellInputElem === null) {
    alert("Failed to get input element");
    return;
  }
  
  // set event listener
  shellInputElem.addEventListener("keyup", function (ev) {
    if (ev.key === "Enter") {
      const inputContent = ???.value;
      if (addTodoRegex.test(inputContent)) {
        ???
      } else if (???) {
        ???
      }
    }
  })

  // or: btnElem.addEventListener("click", function () {})
}

window.addEventListener("load", initializeTodoApp);
