/// <reference types="vite/client" />

//默认返回
export interface Response<T> {
    message: string;
    code: number;
    data: T | null;
}

export interface RoomEntryProps {
    roomId: number;
    roomName: string;
    lastMessage: MessageProps | null;
    onDelete: (index: number) => void;
    selectedRoomId:number | null;
    setSelectedRoomId: React.Dispatch<React.SetStateAction<number | null>>; 
}

export interface MessageProps {
    messageId: number;
    roomId: number;
    sender: string;
    content: string;
    time: number;
    user: string;
}

export interface Message {
    messageId: number;
    roomId: number;
    sender: string;
    content: string;
    time: number;
}

export interface RoomPreviewInfo {
    roomId: number;
    roomName: string;
    lastMessage: MessageProps | null;
}

//创建房间
export interface RoomAddArgs {
    user: string;
    roomName: string;
}

export interface RoomAddRes {
    roomId: number;
}

//获取房间列表
export interface RoomListRes {
    rooms: RoomPreviewInfo[];
}

//删除房间
export interface RoomDeleteArgs {
    user: string;
    roomId: number;
}

//添加一条消息
export interface MessageAddArgs {
    roomId: number;
    content: string;
    sender: string;
}

//获取某一房间的历史消息记录
export interface RoomMessageListArgs {
    roomId: number;
}

export interface RoomMessageListRes {
    messages: Message[];
}

//更新消息列表
export interface RoomMessageGetUpdateArgs {
    roomId: number;
    sinceMessageId: number;
}

export interface RoomMessageGetUpdateRes {
    messages: Message[];
}