import { useEffect, useState } from "react";
import useSWR from "swr";
import useSWRMutation from "swr/mutation";
import { Link } from 'react-router-dom';

import "./ChatRoom.css";
import { RoomEntry } from "./RoomEntry";
import {MessageItem} from "./MessageItem";

import { getFetcher } from "../../util";
import { postFetcher } from "../../util";

// import { RoomAddArgs } from "../../vite-env";
// import { RoomAddRes } from "../../vite-env";
import { RoomListRes } from "../../vite-env";
// import { RoomDeleteArgs } from "../../vite-env";
// import { MessageAddArgs } from "../../vite-env";
// import { RoomMessageListArgs } from "../../vite-env";
import { RoomMessageListRes } from "../../vite-env";
// import { RoomMessageGetUpdateArgs } from "../../vite-env";
// import { RoomMessageGetUpdateRes } from "../../vite-env";


export default function ChatRoom () {

//定义部分
    var ID;
    if(localStorage.getItem('latestRoomId')) {
        ID = Number(localStorage.getItem('latestRoomId'));
    }else {
        ID = null;
    }

    const [roomId, setRoomId] = useState<number | null>(ID);//定义“全局变量”roomId,选中房间时更改
    const [isAddingRoom,setIsAddingRoom]=useState(false);//添加房间弹窗定义
    const nickname = localStorage.getItem('nickname')??'';//昵称
    var text = "";
    var room_text = "";
    
    //post请求(借助trigger)
    //创建房间
    const { trigger: addTrigger, isMutating } = useSWRMutation <
    { roomId: number },
    null,
    string,
    {
        user: string;
        roomName: string;
    }
    >("/api/room/add", postFetcher);
    // if(isMutating)return <Loading />;


    //获取房间列表
    const{
        data:roomData,
        // error:roomError,
        // isLoading:roomIsLoading,
    } = useSWR<RoomListRes>("/api/room/list",getFetcher, {
        refreshInterval: 1000,
    });
    // if(roomIsLoading)return<Loading />;
    // if(roomError)return<Errorwindow />;
    

    //删除房间
    const { trigger: deleteTrigger } = useSWRMutation <
    null,
    null,
    string,
    {
        user: string;
        roomId: number | null;
    }
    >("/api/room/delete", postFetcher);


    //添加一条消息
    const { trigger: messageTrigger } = useSWRMutation <
    null,
    null,
    string,
    {
        roomId: number | null;
        content: string;
        sender: string;
    }
    >("/api/message/add", postFetcher);



    //获取某一房间的历史消息记录
    const {
        data:messageListData,
        // error:messageListError,
        // isLoading:messageListIsLoading,
    } = useSWR<RoomMessageListRes>(
        () => {
            //有依赖的数据请求
            if (roomId === null) return false;
            return "/api/room/message/list?roomId=" + roomId;
        },
        getFetcher, 
        {
            refreshInterval: 1000,
        }
    );

    
//函数部分

    //添加房间
    function addRoom(event: { preventDefault: () => void; }) {
        event.preventDefault();
        setIsAddingRoom(true);
    }

    function handleRoomNameChange(event: {preventDefault(): unknown; target: { value: string; }}) {
        room_text = event.target.value;
        event.preventDefault();
    }

    async function addWindowsSubmit() {
        // const newId = 
        await addTrigger({ user:nickname, roomName:room_text });
        // if(newId) setRoomId(Number(newId));
        // console.log(roomId);
        setIsAddingRoom(false);
    }

    function addWindowCancel() {
        setIsAddingRoom(false);
    }


    //删除房间
    async function handleDeleteRoom(deleteRoomId: number) {
        await deleteTrigger({ user:nickname, roomId:deleteRoomId });
    }


    //发送消息
    function messageChange(event: { target: { value: string; }; preventDefault: () => void; }) {
        text = event.target.value;
        event.preventDefault();
    }
    
    async function handleSubmit(event: { preventDefault: () => void; }) {
        
        await messageTrigger({ roomId:roomId, content:text, sender:nickname});
        event.preventDefault();
        
        const inputElement = document.querySelector('.input_blank') as HTMLInputElement;
        if (inputElement) {
            inputElement.value = '';
        }
    }


//渲染内容

    const [isVisible, setIsVisible] = useState(false);

    useEffect(() => {
        setTimeout(() => {
            setIsVisible(true);
        }, 2000);
    }, []);
  
    return(
        <>
        <div className="slide-in">
            <h1>Hello! {nickname}</h1>
        </div>

        <div className={`container ${isVisible ? 'visible' : ''}`}>
            {/* 消息列表 */}
            <div className = "roomList">
                <div className="listTitle room_list">
                    <h3>Hello! {nickname}</h3>
                    <button className="add_room" onClick={addRoom}>新建房间</button>
                </div>
                {/* 渲染房间 */}
                <div className = "roomlist">
                    {roomData?.rooms.map((entry,_) => (
                        <RoomEntry
                            key = {entry.roomId}
                            roomId={entry.roomId}
                            roomName={entry.roomName}
                            lastMessage={entry.lastMessage}
                            onDelete={handleDeleteRoom}
                            setSelectedRoomId={setRoomId} 
                            selectedRoomId={roomId}                                              
                        />
                    ))}
                </div>
            </div>

            {/* 聊天房间页面 */}
            {roomId && <div className = "messagelist">
                <div className="listTitle">
                    <h3>
                    {
                        roomData?.rooms.map((entry,_) => {
                            if(entry.roomId === roomId) {
                                return (
                                    entry.roomName
                                )
                            }
                        })
                    }

                    </h3>
                    <div>
                    <Link to = "/">
                        <button className="back">返回</button>
                    </Link>
                    </div>
                </div>
                
                <div className='chatroom'>
                {messageListData?.messages.map((message, _) => {
                        return (
                            <MessageItem
                                key = {message.roomId}
                                messageId={message.messageId}
                                roomId={message.roomId}
                                sender={message.sender}
                                content={message.content}
                                time={message.time}
                                user={nickname}
                            />
                        );
                    })}
                </div>
                
                <div className="input">
                    <input type="text" required className="input_blank" onChange={messageChange} />
                    <button className="submit" onClick={handleSubmit}>发送</button>
                </div>
            </div>}

            {!roomId && 
            <div className="chatroom_empty-roomId">
                <h2>
                    请点击左侧房间开始聊天！
                </h2>
            </div>
            }

            {isAddingRoom && (
                <div className="add-windows">
                    <h2>添加房间</h2>
                    <div className="add-windows-inputbox">
                        <input type="text" onChange={handleRoomNameChange} required />
                        <label htmlFor="">房间名称</label>
                    </div>
                    <button className='add-windows-button' onClick={addWindowsSubmit}>确认添加</button>
                    <button className='add-windows-button cancel'onClick={addWindowCancel} >取消</button>
                </div>
            )}
        </div>
        </>
    );
}


// function Loading() {
//     return(
//         window.prompt("Loading...")
//     );
// }

// function Errorwindow() {
//     return(
//         window.prompt("Error!")
//     );
// }
