import React , { useEffect, useState } from "react";
import "./ChatRoom.css"; 

//房间组件
interface RoomEntryProps {
    roomId: number;
    roomName: string;
    lastMessage: MessageProps | null;
    onDelete: (index: number) => void;
    selectedRoomId:number;
    setSelectedRoomId: React.Dispatch<React.SetStateAction<number>>; 
}
function RoomEntry (props:RoomEntryProps) {
    
    const [isContextMenuVisible, setContextMenuVisible] = useState(false);
    const [contextMenuStyle, setContextMenuStyle] = useState({});
    // const [deleteId,setDeleteId] = useState<number | null>(null);

    //右键点击
    function handleContextMenu(e: { preventDefault: () => void; button: number; clientY: any; clientX: any; }) {
        e.preventDefault(); // 阻止默认的右键菜单

        if (e.button === 2) {
        const style = {
            top: `${e.clientY}px`,
            left: `${e.clientX}px`,
        };

        // 显示右键菜单
        setContextMenuStyle(style);
        setContextMenuVisible(true);

        // setDeleteId(props.roomId);
        }
        
    }

    //左键点击
    function handleRoomClick () {
        props.setSelectedRoomId(props.roomId);
    }

    //删除房间
    function handleDeleteRoom() {
        setContextMenuVisible(false); 
        props.onDelete(props.roomId);
        if (props.selectedRoomId === props.roomId) {
            props.setSelectedRoomId(-1);
        }
    }
    
    return(
        <>
            {/* 判断该房间是否为选中的房间 */}
            <div className={`room ${props.selectedRoomId === props.roomId ? "clicked" : ""}`} onContextMenu={handleContextMenu} onClick={handleRoomClick}>
                <div>
                    <p>{props.roomName}</p>
                    <p>{props.lastMessage?.time??'刚刚'}</p>
                </div>
                <p>{props.lastMessage?.sender??'[新建了一个房间]'}</p>
            </div>
            {isContextMenuVisible && (
                <div className="context-menu" style={contextMenuStyle}>
                    <div onClick={()=>handleDeleteRoom()}>删除房间</div>
                </div>
            )}
        </>
    );
}

//消息组件
interface MessageProps {
    messageId: number;
    roomId: number;
    sender: string;
    content: string;
    time: number;
}
function MessageItem (props:MessageProps) {
    
    const formattedTime = new Date(props.time).toLocaleString();

    return(
        <>
            <div className="message_item">
                <div className="head_photo">
                    <p>头像</p>
                </div>
                <div className="head">
                    <div className="nickname">
                       <p>{props.sender}:</p>
                       <p className="message_time">{formattedTime}</p>
                    </div>
                    <div>
                        <div className="message">
                            <p>{props.content}</p>
                        </div>
                    </div>     
                </div>   
            </div>     
        </>
    ); 
    
}



export default function ChatRoom () {
    
    //get请求获取聊天房间列表


    //选择的房间的状态定义
    const [selectedRoomId, setSelectedRoomId] = useState(-1);
    
    // 房间组件定义
    type Entry = {
        roomname:string;
    };
    const [roomEntries, setRoomEntries] = useState<Entry[]>([]);
    var room_text = "";

    //消息组件定义
    type Messages = {
        content: string;
        time: number;
        roomId:number;
      };
    const [messages, setMessages] = useState<Messages[]>([]);
    var text = "";

    //添加房间弹窗定义
    const[isAddingRoom,setIsAddingRoom]=useState(false);

    //添加房间
    function addRoom(event: { preventDefault: () => void; }) {
        event.preventDefault();
        setIsAddingRoom(true);
        // setRoomEntries(prevEntries => [...prevEntries, prevEntries.length]);
    }

    function handleRoomNameChange(event: {
        preventDefault(): unknown; target: { value: string; }
}) {
        room_text = event.target.value;
        event.preventDefault();
    }

    function addWindowsSubmit() {
        const newEntry = {
            roomname:room_text
        }
        setRoomEntries(prevEntries => [...prevEntries, newEntry]);
        setIsAddingRoom(false);
    }

    //删除房间
    function handleDeleteRoom(index: number) {
        setRoomEntries(prevEntries => prevEntries.filter((_, i) => i !== index)); // 通过过滤删除指定索引的房间
    }

    //消息框内容改变监测函数
    function messageChange(event: { target: { value: string; }; preventDefault: () => void; }) {
        text = event.target.value;
        event.preventDefault();
    }
    
    //提交函数
    function handleSubmit(event: { preventDefault: () => void; }) {
        const currentTime = Date.now();
        const newMessage = {
            content:text,
            time:currentTime,
            roomId:selectedRoomId
        }

        event.preventDefault();
        
        setMessages(prevMessages => [...prevMessages, newMessage]);
        
        console.log(messages);
        
        const inputElement = document.querySelector('.input_blank') as HTMLInputElement;

        if (inputElement) {
            inputElement.value = '';
        }

    }

    // useEffect(() => {
        //     const interval = setInterval(() => {
        //         setMessages(prevMessages => [...prevMessages, newMessage]);
        //     },1000);
        //     return () => {clearInterval(interval);}
        // },[selectedRoomId])

    //渲染内容
    return(
        <>
        <div className="container">
            {/* 消息列表 */}
            <div className = "roomList">
                <div className="listTitle room_list">
                    <h3>昵称</h3>
                    <button className="add_room" onClick={addRoom}>新建房间</button>
                </div>
                {/* 渲染房间 */}
                <div className = "roomlist">
                    {roomEntries.map((entry,index) => (
                        <RoomEntry
                            key={index}
                            roomId={index}
                            onDelete={handleDeleteRoom}
                            roomName={entry.roomname}
                            lastMessage={null}
                            setSelectedRoomId={setSelectedRoomId} 
                            selectedRoomId={selectedRoomId}                                              
                        />
                    ))}
                </div>
            </div>

            {/* 聊天房间页面 */}
            <div className = "messagelist">
                <div className="listTitle">
                    <h3>房间一</h3>
                </div>
                
                <div className='chatroom'>
                {messages.map((message, index) => {
                        if (message.roomId === selectedRoomId) {
                            return (
                                <MessageItem
                                    key={index}
                                    messageId={index}
                                    roomId={message.roomId}
                                    sender={"昵称"}
                                    content={message.content}
                                    time={message.time}
                                />
                            );
                        } else {
                            return null;
                        }
                    })}
                </div>
                
                <div className="input">
                    <input type="text" required className="input_blank" onChange={messageChange} />
                    <button className="submit" onClick={handleSubmit}>发送</button>
                </div>
            </div>

            {isAddingRoom && (
                <div className="add-windows">
                    <h2>添加房间</h2>
                    <div className="add-windows-inputbox">
                        <input type="text" onChange={handleRoomNameChange} required />
                        <label htmlFor="">房间名称</label>
                    </div>
                    <button className='add-windows-button' onClick={addWindowsSubmit}>确认添加</button>
                </div>
            )}
        </div>
        </>
    );
}