import React , { useEffect, useState } from "react";
import "./ChatRoom.css"; 
import {RoomEntryProps} from "../../vite-env";

export function RoomEntry (props:RoomEntryProps) {
    
    const [isContextMenuVisible, setContextMenuVisible] = useState(false);
    const [contextMenuStyle, setContextMenuStyle] = useState({});
    let formattedTime;
    if (props.lastMessage?.time !== undefined) {
        formattedTime = new Date(props.lastMessage?.time).toLocaleString();
    }
    // const [deleteId,setDeleteId] = useState<number | null>(null);

    //右键点击
    function handleContextMenu(e: { preventDefault: () => void; button: number; clientY: any; clientX: any; }) {
        e.preventDefault(); // 阻止默认的右键菜单

        if (e.button === 2) {
        const style = {
            top: `${e.clientY}px`,
            left: `${e.clientX}px`,
        };

        // 显示右键菜单
        setContextMenuStyle(style);
        setContextMenuVisible(true);

        // setDeleteId(props.roomId);
        }
        
    }

    //左键点击
    function handleRoomClick () {
        props.setSelectedRoomId(props.roomId);
    }

    //删除房间
    function handleDeleteRoom() {
        setContextMenuVisible(false); 
        props.onDelete(props.roomId);
        if (props.selectedRoomId === props.roomId) {
            props.setSelectedRoomId(null);
        }
    }
    
    return(
        <>
            {/* 判断该房间是否为选中的房间 */}
            <div className={`room ${props.selectedRoomId === props.roomId ? "clicked" : ""}`} onContextMenu={handleContextMenu} onClick={handleRoomClick}>
                <div>
                    <h3>{props.roomName}</h3>
                    <p className="room-time">
                        {formattedTime}
                        {/* {props.lastMessage?.time === undefined && '刚刚'} */}
                    </p>
                </div>
                
                <p className="room-message">{props.lastMessage?.sender??'系统'} : { props.lastMessage?.content??'无消息'}</p>
                
            </div>
            {isContextMenuVisible && (
                <div className="context-menu" style={contextMenuStyle}>
                    <div onClick={()=>handleDeleteRoom()}>删除房间</div>
                </div>
            )}
        </>
    );
}