import React , { useEffect, useState } from "react";
import "./ChatRoom.css"; 
import {MessageProps} from "../../vite-env";

export function MessageItem (props:MessageProps) {
    
    const formattedTime = new Date(props.time).toLocaleString();
    const nickname = props.sender;
    const firstCharacter = nickname.charAt(0);

    return(
        <>
            <div className={`message_item ${props.user === nickname ? "host" : ""}`}>
                <div className="head_photo">
                    <p>{firstCharacter}</p>
                </div>
                <div className={`head ${props.user === nickname ? "host" : ""}`}>
                    <div className="nickname">
                       <p>{props.sender}:</p>
                       <p className="message_time">{formattedTime}</p>
                    </div>
                    <div>
                        <div className="message">
                            <p>{props.content}</p>
                        </div>
                    </div>     
                </div>   
            </div>     
        </>
    ); 
    
}