import React , { useState } from "react";
import "./ChatRoom.css"; 

interface RoomEntryProps {
    roomId: number;
    roomName: string;
    lastMessage: MessageProps | null;
    onDelete: (index: number) => void;
}
function RoomEntry (props:RoomEntryProps) {
    
    const [isContextMenuVisible, setContextMenuVisible] = useState(false);
    const [contextMenuStyle, setContextMenuStyle] = useState({});

    function handleContextMenu(e: { preventDefault: () => void; button: number; clientY: any; clientX: any; }) {
        e.preventDefault(); // 阻止默认的右键菜单

        if (e.button === 2) {
        const style = {
            top: `${e.clientY}px`,
            left: `${e.clientX}px`,
        };

        // 显示右键菜单
        setContextMenuStyle(style);
        setContextMenuVisible(true);
        }
        else if (e.button === 1)
        {
            
        }
    }

    function handleDeleteRoom() {
        setContextMenuVisible(false); 
        props.onDelete(props.roomId);
    }
    
    return(
        <>
            <div className="room" onContextMenu={handleContextMenu}>
                <div>
                    <p>房间</p>
                    <p>时间</p>
                </div>
                <p>{props.lastMessage?.sender??'昵称'}</p>
            </div>
            {isContextMenuVisible && (
                <div className="context-menu" style={contextMenuStyle}>
                    <div onClick={handleDeleteRoom}>删除房间</div>
                </div>
            )}
        </>
    );
}

interface MessageProps {
    messageId: number;
    roomId: number;
    sender: string;
    content: string;
    time: number;
}
function MessageItem (props:MessageProps) {
    
    const formattedTime = new Date(props.time).toLocaleString();

    return(
        <>
            <div className="message_item">
                <div className="head_photo">
                    <p>头像</p>
                </div>
                <div className="head">
                    <div className="nickname">
                       <p>{props.sender}:</p>
                       <p className="message_time">{formattedTime}</p>
                    </div>
                    <div>
                        <div className="message">
                            <p>{props.content}</p>
                        </div>
                    </div>     
                </div>   
            </div>     
        </>
    );
}



export default function ChatRoom () {
    
    type Entry = number;
    const [roomEntries, setRoomEntries] = useState<Entry[]>([]);
    type Messages = {
        content: string;
        time: number;
      };
    const [messages, setMessages] = useState<Messages[]>([]);
    
    var text = "";

    function addRoom(event: { preventDefault: () => void; }) {
        event.preventDefault();
        setRoomEntries(prevEntries => [...prevEntries, prevEntries.length]);
    }

    function handleDeleteRoom(index: number) {
        setRoomEntries(prevEntries => prevEntries.filter((_, i) => i !== index)); // 通过过滤删除指定索引的房间
    }

    function messageChange(event: { target: { value: string; }; preventDefault: () => void; }) {
        text = event.target.value;
        event.preventDefault();
    }
    
    function handleSubmit(event: { preventDefault: () => void; }) {
        const currentTime = Date.now();
        const newMessage = {
            content:text,
            time:currentTime
        }

        event.preventDefault();
        setMessages(prevMessages => [...prevMessages, newMessage]);
        console.log(messages);
        
        const inputElement = document.querySelector('.input_blank') as HTMLInputElement;

        if (inputElement) {
            inputElement.value = '';
        }

    }

    return(
        <>
        <div className="container">
            {/* 消息列表 */}
            <div className = "roomList">
                <div className="listTitle room_list">
                    <h3>昵称</h3>
                    <button className="add_room" onClick={addRoom}>新建房间</button>
                </div>
                <div className = "roomlist">
                    {roomEntries.map((_,index) => (
                        <RoomEntry
                            key={index}
                            roomId={0}
                            onDelete={handleDeleteRoom} 
                            roomName={""} 
                            lastMessage={null}                   
                        />
                    ))}
                </div>
                

            </div>

            <div className = "messagelist">
                <div className="listTitle">
                    <h3>房间一</h3>
                </div>
                
                <div className='chatroom'>
                {messages.map((message,index) => (
                    <MessageItem
                        messageId={index} 
                        roomId={0} 
                        sender={"昵称"}
                        content={message.content}  
                        time={message.time}                    
                    />
                ))}
                </div>
                
                <div className="input">
                    <input type="text" required className="input_blank" onChange={messageChange} />
                    <button className="submit" onClick={handleSubmit}>发送</button>
                </div>
            </div>
        </div>
        </>
    );
}