// types.ts
export interface RoomPreviewInfo {
  roomId: number;
  roomName: string;
  lastMessage: Message | null;
}

export interface RoomInfo {
  roomId: number;
  roomName: string;
  creater: string;
}

export interface Message {
  messageId: number;  // 消息 id
  roomId: number;     // 房间 id
  sender: string;     // 发送人的 username
  content: string;    // 消息内容
  time: number;  // 消息发送时间戳
}

// room list
export interface RoomListRes {
  rooms: RoomPreviewInfo[];
}

// message list
export interface RoomMessageListRes {
  messages: Message[];
}

// update message
export interface UpdateMessageRes {
  messages: Message[];
}

// Props
export interface RoomListProps {
  rooms: RoomPreviewInfo[];
  selectedRoomId: number | null;
  onSelect: (id: number) => void;
  onAddRoom: (roomName: string) => Promise<number>;
  onDeleteRoom: (id: number) => void;
}

export interface ChatWindowProps {
  roomName: string;
  messages: Message[];
  onSendNewMessage: (newMessage: string) => void;
}