// app/api/rooms/route.ts (or similar)
import { NextResponse } from 'next/server';
import { listRoom } from '@/server/db/index';
import { RoomPreviewInfo } from '@/types';

// Define the response type (this is good practice!)
interface ApiResponse {
  code: number;
  message?: string;
  data?: {rooms: RoomPreviewInfo[]};
}

// Handle GET requests
export async function GET() {
  try {
    // FIX: Add the 'await' keyword here
    const roomPreviewList = await listRoom(); 
    
    // Now, roomPreviewList is correctly an array ([] or [{...}, ...])
    return NextResponse.json({
      code: 0,
      data: { rooms: roomPreviewList } // This will now be correct
    } satisfies ApiResponse);
    
  } catch (error) {
    console.error('Failed to load room info:', error);
    
    return NextResponse.json({
      code: 3,
      message: 'Internal server error'
    } satisfies ApiResponse, {
      status: 500
    });
  }
}

// 处理其他方法
export async function POST() {
  return NextResponse.json({
    code: 1,
    message: 'Method not allowed'
  } satisfies ApiResponse, {
    status: 405
  });
}

export async function PUT() {
  return NextResponse.json({
    code: 1,
    message: 'Method not allowed'
  } satisfies ApiResponse, {
    status: 405
  });
}

export async function DELETE() {
  return NextResponse.json({
    code: 1,
    message: 'Method not allowed'
  } satisfies ApiResponse, {
    status: 405
  });
}