// src/app/layout.tsx（服务器组件，无需添加'use client'）
import { Suspense } from 'react';
import type { Metadata } from 'next';
import { Inter } from 'next/font/google';

const inter = Inter({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'Chatroom',
  description: 'X-Lab chatroom',
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="en">
      <body className={inter.className}>
        {/* 关键：用Suspense包裹所有页面组件，处理客户端状态缺失 */}
        <Suspense fallback={<div className="loading">加载中...</div>}>
          {children} {/* 这里的children就是page.tsx（客户端组件） */}
        </Suspense>
      </body>
    </html>
  );
}