// src/api/config.ts

// 环境变量配置（建议将敏感信息放在.env文件中）
const API_BASE_URL = "";

// 核心API端点配置
export const API_ENDPOINTS = {
  // 房间管理
  ROOMS: {
    LIST: `${API_BASE_URL}/api/room/list`,
    ADD: `${API_BASE_URL}/api/room/add`,
    DELETE: `${API_BASE_URL}/api/room/delete`,
  },
  
  // 消息管理
  MESSAGES: {
    LIST: `${API_BASE_URL}/api/room/message/list`,
    ADD: `${API_BASE_URL}/api/message/add`,
    UPDATE: `${API_BASE_URL}/api/room/message/getUpdate`,
  },
} as const;

// 类型导出（可选，增强类型安全）
export type ApiEndpoints = typeof API_ENDPOINTS;