package controller

import (
	"Pastebin/app/response"
	"Pastebin/model"
	"errors"
	"fmt"
	"math/rand"
	"net/http"
	"strconv"
	"time"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
	"gorm.io/gorm"
)

var letters = []rune("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")

func randStr(n int) string {
	rand.Seed(time.Now().UnixNano())
	b := make([]rune, n)
	for i := range b {
		b[i] = letters[rand.Intn(len(letters))]
	}
	return string(b)
}
func Text(c echo.Context) error {
	var rec LIST
	rec.Id = 0
	var s string
	for {
		s = randStr(4)
		if err := model.DB.Table("lists").Where("name = ?", s).First(&LIST{}).Error; errors.Is(err, gorm.ErrRecordNotFound) {
			rec.Name = s
			logrus.Error("Genarating String Success!")
			break
		}
		logrus.Info("Genarating New String")
	}
	rec.Password = c.Request().PostFormValue("Password")
	rec.Clicktimes, _ = strconv.Atoi(c.Request().PostFormValue("Clicktimes"))
	rec.Remaintime, _ = strconv.Atoi(c.Request().PostFormValue("Remaintime"))
	rec.Txt = c.Request().PostFormValue("Txt")
	rec.Type = false
	tm := time.Now()
	rec.Starttime = tm.Unix()
	if err := model.DB.Table("lists").Debug().Create(&rec).Error; err != nil {
		logrus.Error(err)
	}
	println("Insert TEXT success!")
	s = fmt.Sprintf("WebCode:%s", rec.Name)
	return response.SendResponse(c, http.StatusOK, "Insert TEXT success!", s)
}
func File(c echo.Context) error {
	var rec LIST
	rec.Id = 0
	var s string
	for {
		s = randStr(4)
		if err := model.DB.Table("lists").Where("name = ?", s).First(&LIST{}).Error; errors.Is(err, gorm.ErrRecordNotFound) {
			rec.Name = s
			logrus.Error("Genarating String Success!")
			break
		}
		logrus.Info("Genarating New String")
	}
	rec.Password = c.Request().PostFormValue("Password")
	rec.Clicktimes, _ = strconv.Atoi(c.Request().PostFormValue("Clicktimes"))
	rec.Remaintime, _ = strconv.Atoi(c.Request().PostFormValue("Remaintime"))
	tm := time.Now()
	rec.Starttime = tm.Unix()
	if err := c.Request().ParseMultipartForm(100000); err != nil {
		logrus.Error(err)
	}
	file, fileHeader, err := c.Request().FormFile("File")
	if err != nil {
		logrus.Error(err)
	}
	defer file.Close()
	fmt.Printf("the uploaded file: name[%s], size[%d], header[%#v]\n",
		fileHeader.Filename, fileHeader.Size, fileHeader.Header)
	data := make([]byte, fileHeader.Size)
	_, err = file.Read(data)
	if err != nil {
		logrus.Error(err)
	}
	rec.File = data
	rec.Type = true
	if err := model.DB.Table("lists").Debug().Create(&rec).Error; err != nil {
		logrus.Error(err)
	}
	println("Insert FILE success!")
	s = fmt.Sprintf("WebCode:%s", rec.Name)
	return response.SendResponse(c, http.StatusOK, "Insert FILE success!", s)
}

func Session(c echo.Context) error {
	var ses SESSION
	kie := c.Request().PostFormValue("Cookie")
	if err := model.DB.Table("sessions").Debug().Where("cookie = ?", kie).First(&ses).Error; err != nil {
		logrus.Error("Not find Session")
		return response.SendResponse(c, http.StatusOK, "", "Status:false")
	}
	tm := time.Now()
	if tm.Unix()-ses.Starttime >= int64(ses.Time) {
		logrus.Info("SESSION Time out")
		if err := model.DB.Table("sessions").Debug().Where("cookie = ?", kie).Delete(&ses).Error; err != nil {
			logrus.Error(err)
		}
		return response.SendResponse(c, http.StatusOK, "", "Status:false")

	} else {
		return response.SendResponse(c, http.StatusOK, "", "Status:true")
	}

}

func Check(c echo.Context) error {
	var rec LIST
	name := c.Request().PostFormValue("Name")
	recPass := c.Request().PostFormValue("Password")
	if err := model.DB.Table("lists").Debug().Where("name = ?", name).First(&rec).Error; err != nil {
		logrus.Error(err)
	}
	tm := time.Now()
	if tm.Unix()-rec.Starttime >= int64(rec.Remaintime) || rec.Clicktimes == 0 {
		if err := model.DB.Table("lists").Debug().Where("name = ?", name).First(&rec).Error; err != nil {
			logrus.Error(err)
		}
		logrus.Info("LIST Time out or Click out")
		return response.SendResponse(c, http.StatusBadRequest, "", "Status:false")
	}
	if rec.Password == recPass {
		CreateSession(c.Request().PostFormValue("Cookie"))
		if err := model.DB.Table("lists").Debug().Where("name = ?", name).Update("Clicktimes", rec.Clicktimes-1).Error; err != nil {
			logrus.Error(err)
		}
		return response.SendResponse(c, http.StatusOK, "", "Status:true")
	} else {
		return response.SendResponse(c, http.StatusOK, "", "Status:false")
	}
}
func Content(c echo.Context) error {
	var rec LIST
	name := c.Request().PostFormValue("Name")
	if err := model.DB.Table("lists").Debug().Where("name = ?", name).First(&rec).Error; err != nil {
		logrus.Error(err)
		return response.SendResponse(c, http.StatusBadRequest, "", rec)
	}
	return response.SendResponse(c, http.StatusOK, "", rec)
}
func CreateSession(Cookie string) {
	tm := time.Now()
	if err := model.DB.Table("sessions").Create(&SESSION{0, Cookie, 30, tm.Unix()}); err != nil {
		logrus.Error(err)
	}
	println("Session is Created")
}

type LIST struct {
	Id         int    `gorm:"primary_key;AUTO_INCREMENT"`
	Name       string `json:"Name" form:"Name" query:"Name"`
	Password   string `json:"Password" form:"Password" query:"Password"`
	Type       bool   `json:"Type" form:"Type" query:"Type"`
	Txt        string `json:"Txt" form:"Txt" query:"Txt"`
	File       []byte `gorm:"type:MediumBlob" json:"File" form:"File" query:"File"`
	Clicktimes int    `json:"Clicktimes" form:"Clicktimes" query:"Clicktimes"`
	Remaintime int    `json:"Remaintime" form:"Remaintime" query:"Remaintime"`
	Starttime  int64
}
type SESSION struct {
	Id        int    `gorm:"primary_key;AUTO_INCREMENT"`
	Cookie    string `json:"Cookie" form:"Cookie" query:"Cookie"`
	Time      int    //剩余时间
	Starttime int64
}
