## 1.语言及框架

**Golang echo**

## 2.数据库

**MySQL**

数据组织方式：两个table

**（1）LIST**

```JSON
LIST{
    "Id":"int"
    "Name":"String"//随机生成 并后续用来索引
    "Password":"String"//访问密码
    "Type":"bool" //false 文本型 存放在Txt键值对中 
                  //true 文件型 指针存放在 File键值对中
    "Txt":"String"//存放文本型数据
    "File":"MediumBlob"// 存放文件型数据
    "ClickTimes":"int"//剩余可以点击的次数
    "RemainTime":"int"//剩余可被访问的时间 （sec）
    "Starttime":  "int64"//传入数据的时间
}
```

（2）SESSION

```JSON
SESSION{
    "Id"  :   "int"    
    "Cookie": "string" //获取到的cookie值（访问鉴权页面的cookie）
    "Time"  : "int"    //留存时间
    "Starttime":  "int64"//传入数据的时间
}
```

## 3.项目结构

### （1）submit请求

则在存放数据的LIST表中新增一条数据

### （2）query请求

为方便与前端交互，分为三种情况进行处理，详见API_LIST

**核心**是根据**Name****或****Cookie**查表，然后返回鉴权结果或判断结果，或者是返回内容：文本则用文本形式返回，文件则用文件形式返回

## 4.API_LIST

## 一、提交

### 1.提交文本

```JSON
{host}/submit/text
[POST]

Content-Type:[留空]

[params]
Form-data
body:
{
  "Expiration":"int",//过期时间（sec）
  "Password":"string",//密码
  "ClickTimes":"int"//访问次数
  "RemainTime":"int"//剩余访问时间
  "Text":"string"//文本内容
}

[response]
{
  "WebCode":"string"//随机生成的路由(route) 比如SqMs 
      //对应的网址需自行加上www.host<route>.com
}

[ERROR_CODE]
{
    "200":"运转正常"
    "400":"存在异常"
}
```

示例：

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=NGZjMjgxZDk1ZWUwZGJmODlhZGU1ODI2Nzg3ZmVlYjdfRThSc2V6WkVsQUNwU3d4RGxmWjEzZWxyNzdId253REpfVG9rZW46Ym94Y25kVk9tMmlMbjl5a0ZOdThIRWpNZzVjXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

### 2.提交文件

```JSON
{host}/submit/file
[POST]

Content-Type:[留空]

[params]
Form-data
body:
{
  "Expiration":"int",//过期时间（sec）
  "Password":"string",//密码
  "ClickTimes":"int"//访问次数
  "RemainTime":"int"//剩余访问时间
  "File":"file"//文件
}

[response]
{
  "WebCode":"string"//随机生成的路由(route) 比如SqMs 
      //对应的网址需自行加上www.host<route>.com
}

[ERROR_CODE]
{
    "200":"运转正常"
    "400":"存在异常"
}
```

示例

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=ZGI4ODNkYWNhNGEyNWYyYTUxNTg5NWM1ZjdiOTMwNDJfbDJ3Y0lqMHNZV2QyZTR0NFhlTEVjTEY4R0djQm9DWkVfVG9rZW46Ym94Y25UdGkwTGlRNGUxN1o3WHRTSzRqMW1mXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

## 二、查询

### 1.鉴权

```JSON
{host}/query/session
[POST]

Content-Type:[留空]

[params]
Form-data
body:
{
  "Name":"string",//网站的索引名——提交时随机生成的那个字符串
  "Cookie":"string"//用于检验是否已有session
}

[response]
{
  "Status":"bool"//用于反映查询状态
          //code == true 直接展示
          //code == false 需要输入密码
}

[ERROR_CODE]
{
    "200":"运转正常"
    "400":"查询的链接不存在"
}
```

1.当前不存在session

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=NjA5ZDYwZDVhNzczMmI2YTA0ZTMzMTI5NGM3NmM4NDlfY1FURDVsSDVmeXZGU0V2dTJDREl3RWw2eHNMbmxsVzBfVG9rZW46Ym94Y243cjREREFHWGNsTzZkbVE3YzNWWmRjXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

2.当前存在session

和1的请求一模一样，但是返回不一样的原因是，我把密码验证做了一下，于是Session表中有了这个cookie，所以这次请求后的结果为true

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=NTM1NWI1NTdlNjJiOGVjZGZkZDBjNmJiNjEyZWNiOTlfNjZTWFJOUElsVUlQRmp6NG1Ea00yNkU4S1hzNVJqMUVfVG9rZW46Ym94Y25UUDVva1UydnRkNW9hWDdFdzhHRjlmXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

### 2.密码验证

```JSON
{host}/query/check
[POST]

Content-Type:[留空]

[params]
Form-data
body:
{
  "Name":"string",//网站的索引名——提交时随机生成的那个字符串
  "Password":"string"//传入密码
  "Cookie":"string"//用于添加一个session
}

[response]
{
  "Status":"bool"//用于反映查询状态
  //Code == false 错误
  //Code == true 正确——可以展示内容
}

[ERROR_CODE]
{
    "200":"运转正常"
    "400":"链接超时无法访问或者次数超限"
}
```

1.输入的密码错误

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=NDFkMjVlMzJhOTczNGExODUzMGY3NGQ1MWM4MzcwN2VfOWlHdnd6bmkyOXVER2FWTEZGcmI5VnVXdEJSUHFrT3lfVG9rZW46Ym94Y25tNjBySXJaaVN2NTc4cUZEOHk1M2tlXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

2.输入的密码正确

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=ZjAzMjlkNGVkZmUxNzIxMWZkOGJjZWNiNWRkMzAzYWRfd2gwM3l6REJmNTNpVTdCeE9PUXNaeEE5UHNxdFluNzJfVG9rZW46Ym94Y25ocHBOUzZOUVZkY3RzYUg4TnRIWHZmXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

### 3.查询内容

```JSON
{host}/query/content
[POST]

Content-Type:[留空]

[params]
Form-data
body:
{
  "Name":"string",//网站的索引名——提交时随机生成的那个字符串
}

[response]
{
  "Type":"bool"//用于反映内容类型 false文本型 true文件类型
  "Content":"string or bytes"//取决于type的值
}

[ERROR_CODE]
{
    "200":"运转正常"
    "400":"查询的链接不存在"
}
```

1.查询文本正常

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=YjkwOGI1YWZlZjhkYjFlN2Q5NTZiNjViMTU3OGI0ZmNfVk1iUktoMjBWQm5XMGRJQks1VkplV1M1RFczVEtnMWdfVG9rZW46Ym94Y25ab054a3R2MHlOR0RqaWxQbUJsbXFiXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

2.查询文本失败（没有这个链接）

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=YjZjMWVhZWUzMWE3NTM4MWFjZGY3ZTIzMGIyZjk2YjlfZGpXQ0VSS2VQbGRUbHNrV3JjYkxlNEYyY2VsaDdGa1ZfVG9rZW46Ym94Y25PdmNhSmRLTURoOUJkVURPU3B0QnBjXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)

3.查询文件成功

（失败略 与2类似）

![img](https://xn4zlkzg4p.feishu.cn/space/api/box/stream/download/asynccode/?code=OGE3ZDYxM2QzOGE4ZjgzOGFiOTc5MjE3NGZiNjFjMmJfWFRFUkFDQmMyUThSeTlvY0RSZDlOM1VzVk16YkVQSlVfVG9rZW46Ym94Y25wTUhwSElUeFkzekUzYThTMktaakJnXzE2NzA5NDY4NzQ6MTY3MDk1MDQ3NF9WNA)