package model

import (
	"github.com/sirupsen/logrus"
	"github.com/spf13/viper"
	"gorm.io/driver/mysql"
	"gorm.io/gorm"
)

var DB *gorm.DB

func DBinit() {
	ConnectDatabase()
	err := DB.AutoMigrate(&LIST{})
	if err != nil {
		logrus.Fatal(err)
	}
	println("Connect Success!")
}

func ConnectDatabase() {
	//read in config file
	viper.SetConfigName("conf")
	viper.SetConfigType("toml")
	viper.AddConfigPath("./")
	if err := viper.ReadInConfig(); err != nil {
		logrus.Fatal(err)
	}
	println("Read in config success!")
	//construct request
	loginInfo := viper.GetStringMapString("mysql")
	dbArgs := loginInfo["username"] + ":" + loginInfo["password"] + "@tcp(" +
		loginInfo["ip"] + ":" + loginInfo["port"] + ")/" + loginInfo["db_name"] +
		"?charset=utf8mb4&parseTime=True&loc=Local"
	var err error
	DB, err = gorm.Open(mysql.Open(dbArgs), &gorm.Config{})
	if err != nil {
		logrus.Fatal(err)
	}
	println("mysql connected!")

}

type LIST struct {
	Id         int `gorm:"primary_key;AUTO_INCREMENT"`
	Name       string
	Password   string
	Type       bool
	Txt        string
	File       []byte `gorm:"type:MediumBlob"`
	ClickTimes int
	RemainTime int
}
