package controller

import (
	"Pastebin/app/response"
	"Pastebin/model"
	"fmt"
	"math/rand"
	"net/http"
	"strconv"
	"time"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

var letters = []rune("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")

func randStr(n int) string {
	rand.Seed(time.Now().UnixNano())
	b := make([]rune, n)
	for i := range b {
		b[i] = letters[rand.Intn(len(letters))]
	}
	return string(b)
}
func Text(c echo.Context) error {
	rec := new(LIST)
	rec.Id = 0
	rec.Name = randStr(4)
	rec.Password = c.QueryParam("Password")
	rec.ClickTimes, _ = strconv.Atoi(c.QueryParam("ClickTimes"))
	rec.RemainTime, _ = strconv.Atoi(c.QueryParam("RemainTime"))
	rec.Txt = c.QueryParam("Txt")
	rec.Type = false
	if err := model.DB.Debug().Create(&rec).Error; err != nil {
		logrus.Error(err)
	}
	println("Insert TEXT success!")
	s := fmt.Sprintf("WebCode:%s", rec.Name)
	return response.SendResponse(c, http.StatusOK, "Insert TEXT success!", s)
}
func File(c echo.Context) error {
	rec := new(LIST)
	rec.Id = 0
	rec.Name = randStr(4)
	rec.Password = c.QueryParam("Password")
	rec.ClickTimes, _ = strconv.Atoi(c.QueryParam("ClickTimes"))
	rec.RemainTime, _ = strconv.Atoi(c.QueryParam("RemainTime"))
	rec.File = []byte(c.QueryParam("File"))
	rec.Type = true
	if err := model.DB.Debug().Create(&rec).Error; err != nil {
		logrus.Error(err)
	}
	println("Insert FILE success!")
	s := fmt.Sprintf("WebCode:%s", rec.Name)
	return response.SendResponse(c, http.StatusOK, "Insert FILE success!", s)
}

/*
func Session(c echo.Context) error {

}
func Check(c echo.Context) error {

}
func Content(c echo.Context) error {

}
*/
type LIST struct {
	Id         int `gorm:"primary_key;AUTO_INCREMENT"`
	Name       string
	Password   string
	Type       bool
	Txt        string
	File       []byte `gorm:"type:MediumBlob"`
	ClickTimes int
	RemainTime int
}
