"use client";

import React from "react";
import { Message } from "@/types/chat";

interface MessageItemProps {
  message: Message;
}

export default function MessageItem({ message }: MessageItemProps) {
  // 格式化时间 -> "14:50:22"
  const timeStr = new Date(message.time).toLocaleTimeString("zh-CN", {
    hour: "2-digit",
    minute: "2-digit",
    second: "2-digit",
    hour12: false, // ✅ 使用24小时制
  });

  // 检查是否是用户自己的消息（假设用户名为"You"或"User"）
  const isOwnMessage = message.sender === "You" || message.sender === "User";

  return (
    <div className={`flex mb-4 ${isOwnMessage ? "justify-end" : "justify-start"}`}>
      <div className={`max-w-xs md:max-w-md lg:max-w-lg px-4 py-2 rounded-lg shadow-sm ${isOwnMessage ? "bg-blue-500 text-white" : "bg-gray-100 text-gray-800"}`}>
        <div className="flex items-baseline justify-between mb-1">
          <span className={`text-sm font-semibold ${isOwnMessage ? "text-blue-100" : "text-blue-600"}`}>
            {message.sender}
          </span>
          <span className={`text-xs ml-2 ${isOwnMessage ? "text-blue-200" : "text-gray-500"}`}>
            {timeStr}
          </span>
        </div>
        <p className="text-sm break-words">{message.content}</p>
      </div>
    </div>
  );
}