import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

interface RoomAddArgs {
  user: string;
  roomName: string;
}

export async function POST(req: Request) {
  try {
    const { user, roomName }: RoomAddArgs = await req.json();
    if (!user || !roomName) {
      return NextResponse.json({ code: 1, error: "Missing arguments" });
    }

    const creator = await prisma.user.findFirst({ where: { username: user } });
    if (!creator) {
      return NextResponse.json({ code: 1, error: "User not found" });
    }

    const room = await prisma.room.create({
        data: {
            roomName,
            createdBy: creator.id, // 记录谁是创建者
            users: { connect: { id: creator.id } },    // 创建者自动加入房间
        },
    });

    return NextResponse.json({ code: 0, data: { roomId: room.id } });
  } catch (err: any) {
    console.error("RoomAdd error:", err);
    return NextResponse.json({ code: 1, error: err.message || "Server error" });
  }
}
