import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

export async function POST(req: Request) {
  try {
    const body = await req.json();

    // roomId 可能是 string，要转成 number
    const roomIdRaw = body.roomId;
    const roomId =
      typeof roomIdRaw === "string" ? parseInt(roomIdRaw, 10) : roomIdRaw;

    const content: string = body.content;
    const sender: string = body.sender;

    const created = await prisma.message.create({
      data: {
        roomId,
        content,
        sender,         // 只存字符串
        time: new Date() // 统一用 time 记录时间（也可省略，schema 有 default(now()) 就会自动填）
      },
    });

    return NextResponse.json({
      code: 0,
      data: {
        messageId: created.id,
        time: created.time,
      },
    });
  } catch (err: any) {
    console.error("MessageAdd error:", err);
    return NextResponse.json({ code: 1, error: err.message || "Server error" });
  }
}
