import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

export async function POST(req: Request) {
  const { username, password } = await req.json();
  if (!username || !password) {
    return NextResponse.json({ code: 1, error: "缺少参数" });
  }

  try {
    const exist = await prisma.user.findUnique({ where: { username } });
    if (exist) {
      return NextResponse.json({ code: 1, error: "用户名已存在" });
    }

    const newUser = await prisma.user.create({
      data: { username, password },
    });

    // ✅ 注册成功后返回 username，保证和 login 一致
    return NextResponse.json({ code: 0, username: newUser.username });
  } catch (err) {
    console.error(err);
    return NextResponse.json({ code: 1, error: "注册失败" });
  }
}
