import jwt from "jsonwebtoken";
import { prisma } from "./prisma";
import { cookies } from "next/headers";

const JWT_SECRET = process.env.JWT_SECRET || "dev_secret";

export function signToken(payload: object) {
  return jwt.sign(payload, JWT_SECRET, { expiresIn: "1h" });
}

export async function getUserFromToken(req?: Request) {
  const cookieStore = await cookies();
  const token = cookieStore.get("token")?.value;

  if (!token) return null;

  try {
    const decoded = jwt.verify(token, JWT_SECRET) as { id: string };
    return await prisma.user.findUnique({ where: { id: Number(decoded.id) } });
  } catch {
    return null;
  }
}
