import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

export async function GET(req: Request) {
  try {
    const { searchParams } = new URL(req.url);
    const roomIdRaw = searchParams.get("roomId");
    const roomId = roomIdRaw ? parseInt(roomIdRaw, 10) : NaN;

    if (!Number.isFinite(roomId)) {
      return NextResponse.json({ code: 1, error: "参数缺失或无效" });
    }

    const messages = await prisma.message.findMany({
      where: { roomId },
      orderBy: { time: "asc" }, // ✅ 用 time
    });

    return NextResponse.json({ code: 0, data: { messages } });
  } catch (err: any) {
    console.error("RoomMessageList error:", err);
    return NextResponse.json({ code: 1, error: err.message || "Server error" });
  }
}
