import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

export async function POST(req: Request) {
  try {
    const { roomId } = await req.json();

    if (!roomId) {
      return NextResponse.json({
        code: 1,
        error: "缺少 roomId 参数",
      });
    }

    const roomIdInt = Number(roomId); // ✅ 统一转成 Int

    // 1️⃣ 先清空房间的用户关联
    await prisma.room.update({
      where: { id: roomIdInt },
      data: {
        users: { set: [] }, // 删除所有用户关联
      },
    });

    // 2️⃣ 删除房间的消息
    await prisma.message.deleteMany({
      where: { roomId: roomIdInt }, // ✅ 注意这里
    });

    // 3️⃣ 删除房间本身
    await prisma.room.delete({
      where: { id: roomIdInt },
    });

    return NextResponse.json({
      code: 0,
      message: "房间删除成功（用户保留）",
    });
  } catch (err: any) {
    console.error("DeleteRoom error:", err);
    return NextResponse.json({
      code: 1,
      error: err.message || "删除房间失败",
    });
  }
}
