import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

export async function POST(req: Request) {
  const { username, password } = await req.json();
  if (!username || !password) {
    return NextResponse.json({ code: 1, error: "缺少参数" });
  }

  try {
    const user = await prisma.user.findUnique({ where: { username } });
    if (!user || user.password !== password) {
      return NextResponse.json({ code: 1, error: "用户名或密码错误" });
    }

    // ✅ 返回用户名，前端才能存
    return NextResponse.json({ code: 0, username: user.username });
  } catch (err) {
    console.error(err);
    return NextResponse.json({ code: 1, error: "登录失败" });
  }
}
