"use client";

import React from "react";
import { RoomPreviewInfo } from "@/types/chat";

interface RoomEntryProps {
  room: RoomPreviewInfo;
  isActive: boolean;
  onClick: () => void;
  onDelete: () => void;
}

export default function RoomEntry({ room, isActive, onClick, onDelete }: RoomEntryProps) {
  return (
    <div
      onClick={onClick}
      onContextMenu={(e) => {
        e.preventDefault();
        onDelete();
      }}
      className={`w-full cursor-pointer transition-colors duration-150 ${
        isActive ? "bg-blue-50" : "hover:bg-gray-50"
      }`}
    >
      <div className="p-2">
        {/* 房间名称 */}
        <div className="font-semibold text-gray-800 truncate mb-1">
          {room.roomName}
        </div>
        
        {/* 最后消息或空状态 */}
        {room.lastMessage ? (
          <div className="flex items-center space-x-1">
            {/* 发送者名称 - 美化样式 */}
            <div className="text-xs font-bold text-indigo-700 truncate tracking-wide flex-shrink-0">
              {room.lastMessage.sender}:
            </div>
            {/* 消息内容 - 改为黑色 */}
            <div className="text-xs text-gray-900 truncate flex-1">
              {room.lastMessage.content}
            </div>
          </div>
        ) : (
          <div className="text-xs text-gray-400 italic">暂无消息</div>
        )}
      </div>
    </div>
  );
}
