import { RoomPreviewInfo, Message } from "@/types/chat";

const apiFetch = async (url: string, options?: RequestInit) => {
  const res = await fetch(url, {
    ...options,
    headers: {
      "Content-Type": "application/json",
      ...(options?.headers || {}),
    },
  });

  return res.json();
};

// 房间相关
export async function addRoom(user: string, roomName: string) {
  const res = await fetch("/api/room/add", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ user, roomName }),
  });
  return res.json(); 
}

export async function getRooms() {
  return apiFetch("/api/room/list");
}

export async function deleteRoom(user: string, roomId: number) {
  const res = await fetch("/api/room/delete", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ user, roomId }),
  });
  return res.json();
}

