import { prisma } from "@/lib/prisma";
import { NextResponse } from "next/server";

export async function GET() {
  try {
    const rooms = await prisma.room.findMany({
      include: {
        users: {  // ✅ 一定要 include users
          select: {
            id: true,
            username: true, // 避免把 password 返回出去
          },
        },
        messages: {
          orderBy: { time: "desc" },
          take: 1, // 只取最新一条消息
        },
      },
    });

    const data = rooms.map((room) => ({
      id: room.id,
      roomName: room.roomName,
      users: room.users,
      createdBy: room.createdBy,
      createdAt: room.createdAt.getTime(),
      lastMessage: room.messages[0]
        ? {
            messageId: room.messages[0].id,
            roomId: room.id,
            sender: room.messages[0].sender,
            content: room.messages[0].content,
            time: room.messages[0].time.getTime(),
          }
        : null,
    }));

    return NextResponse.json({ code: 0, data: { rooms: data } });
  } catch (err: any) {
    console.error("Room list error:", err);
    return NextResponse.json({ code: 1, error: "获取房间列表失败" });
  }
}
