'use client';

import "./ChatRoom.css";
import React, { useEffect, useState } from "react";

const backEnd:string = "http://10.171.208.94:8080";

const Profile = [ 'https://pic4.zhimg.com/v2-c5a0d0d57c1a85c6db56e918707f54a3_r.jpg',
                  'https://pic2.zhimg.com/v2-c2e79191533fdc7fced2f658eef987c9_r.jpg',
                  'https://pic4.zhimg.com/v2-bf5f58e7b583cd69ac228db9fdff377f_r.jpg',
                  'https://pic1.zhimg.com/v2-10e9368af9eb405c8844584ad3ad9dd8_r.jpg',
                  'https://picx.zhimg.com/50/v2-63e3500bfd25b6ae7013a6a3b6ce045b_720w.jpg',
                  'https://c-ssl.duitang.com/uploads/blog/202109/20/20210920000906_53764.png']

const RoomProfile = 'https://tse1-mm.cn.bing.net/th/id/OIP-C.0KyBJKAdIGi9SAQc_X62tQHaLr?cb=thvnextc2&rs=1&pid=ImgDetMain';

interface RoomEntryProps {
    roomId: number;
    roomName: string;
    lastSender: { String: string, Valid: boolean };
    lastContent: { String: string, Valid: boolean };
    lastTime: { Time: string, Valid: boolean };
}

interface MessageProps {
    roomId: number;
    roomName: string;
    messages: Array<{
        profile: number;
        sender: string;
        content: string;
        time: string;
    }>;
}

let RoomName: RoomEntryProps[] = []

function RoomEntry ({rooms, onRoomClick} : {rooms: RoomEntryProps[], onRoomClick: (roomId: number, roomName: string) => void}) {
  return (
    <div className="chat-room-nav">
      <div className="sidebar-action">
        <button type="button" className="button" onClick={openOpenDiv}>
          <div className="button-top">New Chat</div>
          <div className="button-bottom"></div>
          <div className="button-base"></div>
        </button>
      </div>

      <div className="chat-list">
        {rooms.map((room) => (
          <div className="chat-item" key={room.roomId} onClick={() => onRoomClick(room.roomId, room.roomName)}>
            <img src={RoomProfile} alt="Avatar" className="avatar" />
            <div className="chat-info">
              <h3>{room.roomName}</h3>
              <span className="chat-message">{room.lastContent && room.lastContent.Valid ? room.lastContent.String : ''}</span>
              <span className="chat-time">{room.lastTime && room.lastTime.Valid ? formatTimeToHoursMinutes(room.lastTime.Time) : ''}</span>
            </div>
          </div> 
        ))}
      </div>
    </div>
  ); 
  // Button From Uiverse.io by njesenberger
}

function formatTimeToHoursMinutes(isoString: string) {
  const date = new Date(isoString);
  const hours = String(date.getHours()).padStart(2, '0'); // 确保两位数
  const minutes = String(date.getMinutes()).padStart(2, '0'); // 确保两位数
  return `${hours}:${minutes}`;
}

function InputRoomNameArea({ onAddNewRoom }: { onAddNewRoom: (roomName: string) => void}) {
  const [roomNameInput, setRoomNameInput] = useState("");

  const handleAddNewRoom = () => {
    onAddNewRoom(roomNameInput);
    setRoomNameInput("");
    closeOpenDiv();
  }
  return (
    <div className="open">
      <div className="roomName-input">
        <h3>Please Enter the New Room Name</h3>
        <input
          type="text"
          className="RoomNameInput"
          placeholder="Start new chat"
          value = {roomNameInput}
          onChange={(e) => setRoomNameInput(e.target.value)}
          onKeyUpCapture={(e: React.KeyboardEvent<HTMLInputElement>) => {
            if (e.key === 'Enter') {
              handleAddNewRoom();
            }
            else if (e.key === 'Escape') {
              closeOpenDiv();
            }
          }}
        />
        <div className="button-container">
          <button className="create-button" onClick={handleAddNewRoom}>Submit</button>
          <button className="cancel-button" onClick={closeOpenDiv}>Cancel</button>
        </div>
      </div>
    </div>
  );
}

function openOpenDiv() {
  const openDiv = document.getElementsByClassName("open")[0] as HTMLDivElement;
  openDiv.style.zIndex = "1000";
  const roomNameInput = document.getElementsByClassName("RoomNameInput")[0] as HTMLInputElement;
  roomNameInput.style.zIndex = "1001";
}

function closeOpenDiv() {
  const openDiv = document.getElementsByClassName("open")[0] as HTMLDivElement;
  openDiv.style.zIndex = "0";
  const roomNameInput = document.getElementsByClassName("RoomNameInput")[0] as HTMLInputElement;
  roomNameInput.style.zIndex = "0";
  (document.getElementsByClassName("RoomNameInput")[0] as HTMLInputElement).value = '';
}

function MessageItem (props: MessageProps & { onAddNewComment: (content: string) => void}) {
  const [inputValue, setInputValue] = useState("");

  if (props.roomId === 0) {
    return <div className="message-item">Please select a room to chat.</div>;
  }

  const handlerSend = () => {
    if (inputValue.trim() === '') {
      alert("Message can't be empty");
      return
    }
    props.onAddNewComment(inputValue);
    setInputValue('');
  }
  return (
    <div className="message-item">
      <div className="message-header">
        <img src={RoomProfile} alt="Avatar" className="avatar" />
        <h2>{props.roomName}</h2>
      </div>
      <div className="message-list">
        {props.messages.map((msg, index) => (
          <div key={index} className="message">
            <img src={Profile[msg.profile]} alt={`${msg.sender}'s avatar`} className="avatar" />
            <div className="message-content">
              <div className="message-info">
                <span className="message-sender">{msg.sender}</span>
                <span className="message-time">{formatTimeToHoursMinutes(msg.time)}</span>
              </div>
              <p className="message-text">{msg.content}</p>
            </div>
          </div>
        ))}
      </div>
      <div className="message-input">
        <input 
        type="text" 
        placeholder="Type a message..." 
        className="Inputarea"
        value={inputValue}
        onChange={(e) => setInputValue(e.target.value)}
        onKeyUpCapture={
          (e: React.KeyboardEvent<HTMLInputElement>) => {
            if (e.key === 'Enter') {
              handlerSend();
            }
        }}/>
        <button className="send-button" onClick={handlerSend}>
          <div className="svg-wrapper-1">
            <div className="svg-wrapper">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 24 24"
                width="24"
                height="24"
              >
                <path fill="none" d="M0 0h24v24H0z"></path>
                <path
                  fill="currentColor"
                  d="M1.946 9.315c-.522-.174-.527-.455.01-.634l19.087-6.362c.529-.176.832.12.684.638l-5.454 19.086c-.15.529-.455.547-.679.045L12 14l6-8-8 6-8.054-2.685z"
                ></path>
              </svg>
            </div>
          </div>
          <span>Send</span>
        </button>
      </div>
    </div>
  );
  // From Uiverse.io by adamgiebl
}

export function ChatRoom({ userName }: { userName: string }) {
  const [rooms, setRooms] = useState<RoomEntryProps[]>([]);
  const [currentRoom, setCurrentRoom] = useState<MessageProps | null>(null);

  useEffect(() => {
    const fetchRooms = async () => {
      try {
        const response = await fetch(backEnd+"/room/list");
        const result = await response.json();
      if (result.code === 0) {
        const ferchedRooms = result.data.map((room:any) => ({
          ...room,
          lastSender: room.lastSender || { String: '', Valid: false },
          laseComment: room.lastComment || { String: '', Valid: false },
          lastTime: room.lastTime || { String: '', Valid: false }
        }));
        setRooms(ferchedRooms);
      }
      } catch (error) {
        console.error("Error fetching rooms:", error);
      }
    }
    fetchRooms();
  }, []);

  const handleRoomClick = async (roomId: number, roomName: string) => {
    setCurrentRoom({
      roomId: roomId,
      roomName: roomName,
      messages: []
    });

    try {
      const response = await fetch(backEnd+`/room/message/list?roomId=${roomId}`)
      const result = await response.json();
      debugger;
      if (result.code === 0) {
        setCurrentRoom({
          roomId: roomId,
          roomName: roomName,
          messages: result.data || []
        });
      } else {
        alert(`Error fetching messages: ${result.msg}`);
        setCurrentRoom({
          roomId: roomId,
          roomName: roomName,
          messages: []
        });
      }
    } catch (error){
        console.error("Error fetching messages:", error);
        alert("Failed to fetch messages. See console for details.");
    }
  }

  async function addNewRoom(roomName: string) {
    if (roomName.trim() === "") {
      alert("Please enter a room name.");
      return;
    }

    try {
      const response = await fetch (backEnd + "/room/add", {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ roomName: roomName })
      })

      const result = await response.json();
      
      if (result.room_id > 0) {
        const newRoom:RoomEntryProps = {
          roomId: result.RoomId,
          roomName: roomName,
          lastSender: { String: '', Valid: false } ,
          lastContent: { String: '', Valid: false },
          lastTime: { Time: '', Valid: false },
        };
        setRooms(prevRooms => [newRoom, ...prevRooms]);
      } else {
        alert("Faile to add a new room" + result.Msg);
      }
    } catch (error) {
        console.error("Error adding new room" + error);
        alert("Error adding new room.");
    }
  }

  const addNewComment = async (content: string) => {
    if (!currentRoom) 
      return;

    let profileId = 0;
    if (userName === '蔡徐坤') {
      profileId = Profile.length - 1;
    } else {
      profileId = Math.floor(Math.random() * (Profile.length-1));
    }

    try {
      const response = await fetch(backEnd + '/room/message/add', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({
          roomId: currentRoom.roomId,
          profile_id: profileId,
          sender: userName,
          content
        })
      })

      const result = await response.json();
      if (result.code != 0) {
        alert(`Error: ${result.Msg}`);
        return;
      }
      
      const newMessage: { profile: number, sender: string, content: string, time: string } = {
          profile: profileId,
          sender: userName,
          content: content,
          time: new Date().toISOString()
      };

      setCurrentRoom(prevRoom => {
          if (!prevRoom) return null;
          return {
              ...prevRoom,
              messages: [...prevRoom.messages, newMessage]
          };
      });

    } catch (error) {
      console.error("Error in addNewComment:", error);
      alert("An error occurred while sending the message.");
    }
  }

  return (
      <div className="chat-room">
        <RoomEntry rooms={rooms} onRoomClick={handleRoomClick}/>
        <MessageItem 
            roomId={currentRoom?.roomId || 0}
            roomName={currentRoom?.roomName || ""}
            messages={currentRoom?.messages || []}
            onAddNewComment={addNewComment}
        />
        <InputRoomNameArea onAddNewRoom={addNewRoom}/>
      </div>
  );
}